<!DOCTYPE html>
<html amp><head><meta charset="utf-8"><meta property="og:url" content="http://reason.com/archives/2017/10/26/the-fragile-generation"><meta name="google-site-verification" content="s2RyPh7YKv2FebnAJPsliBkOOu5IiJHh-32jW9ZR-0I"><meta name="google-site-verification" content="-AmMiilAN-pnjWt369CUWae-VQ-b9wmH4fSGyhbkQxw"><meta name="msvalidate.01" content="212A68A07785B3080038A845C4EE8905"><link rel="shortcut icon" href="/favicon.ico" type="image/x-icon"><title>The Fragile Generation - Reason.com</title><link rel="canonical" href="http://reason.com/archives/2017/10/26/the-fragile-generation"><meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1"><link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css"><style amp-custom>
    	body {
			color: #000;
			font-size: 14px;
			padding: 10px;
    	}
		h1 {
			color: red
		}
		img {
		    color: transparent;
		    font-size: 0;
		    vertical-align: middle;
		}
		.subtitle {
		    font-family: GoodWeb-Book,Helvetica,helvetica,sans-serif;
		    font-weight: 400;
		    font-size: 1.2em;
		    line-height: 1.2em;
		    margin-bottom: 3px;
		}
		.post p {
		    margin-bottom: 1.5em;
		    line-height: 1.4em;
		}
		.addcaption img {
		    margin: 0;
		    height: auto;
		    display: block;
		}
		#masthead h1 {
		    background-image: url(https://d1ai9qtk9p41kl.cloudfront.net/media/images/mainlogo1.png);
		    background-repeat: no-repeat;
		    width: 190px;
		    height: 40px;
		}
		#masthead hgroup h1 a{
			text-indent:-9999px;
			display:block;
		}
		#masthead hgroup h2 {
			display:none;
		}
		a, h1.title a, h2.title a {
		    text-decoration: none;
		    color: #000;
		}
		.post a {
		    color: #fc8600;
		}
		.inner .mainheading .title, .single .mainheading .title {
			margin-bottom: .05em;
		}
		.single .mainheading .subtitle {
		    margin: .25em 0;
		}
		.inner .post .title, .single .post .title {
		    font-size: 2.2em;
		    line-height: 1em;
		}
		body:not(.user) .postcontent .left, body:not(.user) .postcontent .right {
		    clear: both;
		}
		body:not(.user) .postcontent .right {
		    float: right;
		    margin: 0 0 1em 1em;
		}
		span > span.caption {
			clear: both;
			display: block;
		}
		ul.share-buttons{
		  list-style: none;
		  padding: 0;
		}
		ul.share-buttons li{
		  display: inline;
		}
		@media screen and (max-width: 1028px) and (max-width: 580px) and (min-width: 0px) and (min-width: 321px) {
			.addcaption.left img, .addcaption.right img {
			    width: 150px;
			}
			.addcaption.left, .addcaption.right {
	    		width: 150px;
			}
		}
		@media screen and (max-width: 760px) and (min-width: 0px) {
			.post img, span.addcaption.pic {
			    max-width: 296px;
			    height: auto;
			}
			body:not(.user) .postcontent .right {
				float: right;
				margin: 0 0 1em 1em;
			}
		}
		@media screen and (max-width: 1028px) and (min-width: 0px) {
			.inner .mainheading, .single .mainheading {
			    border-bottom: 2px solid #ccc;
			    padding-bottom: 0;
			    margin-bottom: 1em;
			    position: relative;
			}
			.addcaption.right {
			    width: auto;
			    line-height: 1.5em;
			    float: right;
			    margin-left: 2em;
			    text-align: right;
			}
			blockquote {
			    border-left: 5px solid #e6e6e7;
			    padding-left: 1em;
			    margin-bottom: 2em;
			}
		}
		@media screen and (max-width: 1028px) and (max-width: 580px) and (min-width: 0px) and (min-width: 321px) {

	}
    </style><script type="application/ld+json">
    {
		"@context": "http://schema.org",
		"@type": "NewsArticle",
        "mainEntityOfPage": "http://reason.com/archives/2017/10/26/the-fragile-generation",
		"headline": "The Fragile Generation - Reason.com",
		"datePublished": "2017-10-26 06:00:00",
	    "author": {
	      "@type": "Person",
	      "name": "Lenore Skenazy"
	    },
	    "publisher": {
	      "@type": "Organization",
	      "name": "Reason",
	      "logo": {
	        "@type": "ImageObject",
	        "url": "https://d1ai9qtk9p41kl.cloudfront.net/media/images/mainlogo1.png",
	        "width": 186,
	        "height": 39
	      }
	    }
		,
		"image": {
	      "@type": "ImageObject",
	      "url": "https://d1jn4vzj53eli5.cloudfront.net/db/15081729326648.jpg"
	    }    }
    </script><script async custom-element="amp-analytics" src="https://cdn.ampproject.org/v0/amp-analytics-0.1.js"></script><script async custom-element="amp-ad" src="https://cdn.ampproject.org/v0/amp-ad-0.1.js"></script><style amp-boilerplate>body{-webkit-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-moz-animation:-amp-start 8s steps(1,end) 0s 1 normal both;-ms-animation:-amp-start 8s steps(1,end) 0s 1 normal both;animation:-amp-start 8s steps(1,end) 0s 1 normal both}@-webkit-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-moz-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-ms-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@-o-keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}@keyframes -amp-start{from{visibility:hidden}to{visibility:visible}}</style><noscript><style amp-boilerplate>body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}</style></noscript><script async="async" custom-element="amp-youtube" src="https://cdn.ampproject.org/v0/amp-youtube-0.1.js"></script><script async src="https://cdn.ampproject.org/v0.js"></script><meta property="og:title" content="The Fragile Generation"><meta property="og:image" content="https://d1ai9qtk9p41kl.cloudfront.net/media/images/logo-s.png?r=8487"><meta property="og:site_name" content="Reason.com"><meta property="og:type" content="website"></head><body class="hnrblog single print">
<div id="masthead">
<hgroup><h1><a href="//reason.com/">Reason.com</a></h1>
		<h2>Free Minds &amp; Free Markets</h2>
</hgroup></div>
<article class="post"><header class="mainheading"><h2 class="title"><a href="//reason.com/archives/2017/10/26/the-fragile-generation">The Fragile Generation</a><span class="editor"></span></h2>
							<h2 class="subtitle">Bad policy and paranoid parenting are making kids too safe to succeed.</h2>
					<p class="byline"><a href="//reason.com/people/lenore-skenazy/all" rel="author">Lenore Skenazy</a> &amp; <a href="//reason.com/people/jonathan-haidt/all" rel="author">Jonathan Haidt</a><br><time datetime="2017-10-26T10:00:00+00:00">Oct. 26, 2017 6:00 am</time></p>
		<div class="social-icons">
			<ul class="share-buttons"><li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u=http://reason.com/archives/2017/10/26/the-fragile-generation" target="_blank" title="Share on Facebook"><i class="fa fa-facebook-square fa-lg"></i></a></li>
				<li class="twitter"><a href="https://twitter.com/intent/tweet?source=http://reason.com/archives/2017/10/26/the-fragile-generation&amp;text=The+Fragile+Generation%20http://reason.com/archives/2017/10/26/the-fragile-generation" target="_blank" title="Tweet"><i class="fa fa-twitter fa-lg"></i></a></li>
				<li class="googleplus"><a href="https://plus.google.com/share?url=http://reason.com/archives/2017/10/26/the-fragile-generation" target="_blank" title="Share on Google+"><i class="fa fa-google-plus fa-lg"></i></a></li>
					<li class="reddit"><a href="http://www.reddit.com/submit?url=http://reason.com/archives/2017/10/26/the-fragile-generation&amp;title=The+Fragile+Generation" target="_blank" title="Submit to Reddit"><i class="fa fa-reddit-alien fa-lg"></i></a></li>
					<li class="mailto"><a href="mailto:?subject=The%20Fragile%20Generation%20-%20shared%20from%20Reason.com&amp;body=http://reason.com/archives/2017/10/26/the-fragile-generation%20Bad%20policy%20and%20paranoid%20parenting%20are%20making%20kids%20too%20safe%20to%20succeed." target="_blank" title="Email"><i class="fa fa-envelope fa-lg"></i></a></li>
			</ul></div>
	</header><div class="entry p402_premium postcontent">
								<amp-ad width="320" height="50" type="doubleclick" data-slot="/1006247/amp_mobile_top1"></amp-ad><p>One day last year, a citizen on a prairie path in the Chicago suburb of Elmhurst came upon a teen boy chopping wood. Not a body. Just some already-fallen branches. Nonetheless, the onlooker called the cops.</p>
<p>Officers interrogated the boy, who said he was trying to build a fort for himself and his friends. A local news site reports the police then "took the tools for safekeeping to be returned to the boy's parents."</p>
<p>Elsewhere in America, preschoolers at the Learning Collaborative in Charlotte, North Carolina, were thrilled to receive a set of gently used playground equipment. But the kids soon found out they would not be allowed to use it, because it was resting on grass, not wood chips. "It's a safety issue," explained a day care spokeswoman. Playing on grass is against local regulations.</p>
<amp-ad width="300" height="250" type="doubleclick" data-slot="/1006247/amp_mobile_middle1"></amp-ad><p>And then there was the query that ran in <em>Parents</em> magazine a few years back: "Your child's old enough to stay home briefly, and often does. But is it okay to leave her and her playmate home while you dash to the dry cleaner?" Absolutely not, the magazine averred: "Take the kids with you, or save your errand for another time." After all, "you want to make sure that no one's feelings get too hurt if there's a squabble."</p>
<p>The principle here is simple: This generation of kids must be protected like none other. They can't use tools, they can't play on grass, and they certainly can't be expected to work through a spat with a friend.</p>
<p>And this, it could be argued, is why we have "safe spaces" on college campuses and millennials missing adult milestones today. We told a generation of kids that they can never be too safe&mdash;and they believed us.</p>
<h1>Safety First</h1>
<p>We've had the best of intentions, of course. But efforts to protect our children may be backfiring. When we raise kids unaccustomed to facing anything on their own, including risk, failure, and hurt feelings, our society and even our economy are threatened. Yet modern child-rearing practices and laws seem all but designed to cultivate this lack of preparedness. There's the fear that everything children see, do, eat, hear, and lick could hurt them. And there's a newer belief that has been spreading through higher education that words and ideas themselves can be traumatizing.</p>
<p>How did we come to think a generation of kids can't handle the basic challenges of growing up?</p>
<p>Beginning in the 1980s, American childhood changed. For a variety of reasons&mdash;including shifts in parenting norms, new academic expectations, increased regulation, technological advances, and especially a heightened fear of abduction (missing kids on milk cartons made it feel as if this exceedingly rare crime was rampant)&mdash;children largely lost the experience of having large swaths of unsupervised time to play, explore, and resolve conflicts on their own. This has left them more fragile, more easily offended, and more reliant on others. They have been taught to seek authority figures to solve their problems and shield them from discomfort, a condition sociologists call "moral dependency."</p>
<p>This poses a threat to the kind of open-mindedness and flexibility young people need to thrive at college and beyond. If they arrive at school or start careers unaccustomed to frustration and misunderstandings, we can expect them to be hypersensitive. And if they don't develop the resources to work through obstacles, molehills come to look like mountains.</p>
<p>This magnification of danger and hurt is prevalent on campus today. It no longer matters what a person intended to say, or how a reasonable listener would interpret a statement&mdash;what matters is whether any individual <em>feels</em> offended by it. If so, the speaker has committed a "microaggression," and the offended party's purely subjective reaction is a sufficient basis for emailing a dean or filing a complaint with the university's "bias response team." The net effect is that both professors and students today report that they are walking on eggshells. This interferes with the process of free inquiry and open debate&mdash;the active ingredients in a college education.</p>
<p>And if that's the case already, what of the kids still in grammar school, constantly reminded they might accidentally hurt each other with the wrong words? When today's 8-year-olds become the 18-year-olds starting college, will they still view free speech as worthy of protecting? As Daniel Shuchman, chairman of the free speech-promoting Foundation for Individual Rights in Education (FIRE), puts it, "How likely are they to consider the First Amendment essential if they start learning in fifth grade that you're forbidden to say&mdash;or even think&mdash;certain things, especially at school?"</p>
<p>Parents, teachers, and professors are talking about the growing fragility they see. It's hard to avoid the conclusion that the overprotection of children and the hypersensitivity of college students could be two sides of the same coin. By trying so hard to protect our kids, we're making them too safe to succeed.</p>
<h1>Children on a Leash</h1>
<p>If you're over 40, chances are good that you had scads of free time as a child&mdash;after school, on weekends, over the summer. And chances are also good that, if you were asked about it now, you'd go on and on about playing in the woods and riding your bike until the streetlights came on.</p>
<p>Today many kids are raised like veal. Only 13 percent of them even walk to school. Many who take the bus wait at the stop with parents beside them like bodyguards. For a while, Rhode Island was considering a bill that would prohibit children from getting off the bus in the afternoon if there wasn't an adult waiting to walk them home. This would have applied until seventh grade.</p>
<p>As for summer frolicking, campers don't just have to take a buddy with them wherever they go, including the bathroom. Some are now required to take two&mdash;one to stay with whoever gets hurt, the other to run and get a grown-up. Walking to the john is treated like climbing Mt. Kilimanjaro.</p>
<p>After school, kids no longer come home with a latchkey and roam the neighborhood. Instead, they're locked into organized, supervised activities. Youth sports are a $15 billion business that has grown by 55 percent since just 2010. Children as young as third grade are joining traveling teams&mdash;which means their parents spend a lot of time in the car, too. Or they're at tutoring. Or they're at music lessons. And if all else fails, they are in their rooms, online.</p>
<p><amp-youtube data-videoid="6-SrsJiq0AE" layout="responsive" width="560" height="340"></amp-youtube></p>
<p>Even if parents want to shoo their kids outside&mdash;and don't come home till dinner!&mdash;it's not as easy as it once was. Often, there are no other children around to play with. Even more dishearteningly, adults who believe it's good for young people to run some errands or play kickball down the street have to think twice about letting them, because busybodies, cops, and social workers are primed to equate "unsupervised" with "neglected and in danger."</p>
<p>You may remember the story of the Meitivs in Maryland, investigated twice for letting their kids, 10 and 6, walk home together from the park. Or the Debra Harrell case in South Carolina, where a mom was thrown in jail for allowing her 9-year-old to play at the sprinkler playground while she worked at McDonald's. Or the 8-year-old Ohio boy who was supposed to get on the bus to Sunday school, but snuck off to the Family Dollar store instead. His dad was arrested for child endangerment.</p>
<p>These examples represent a new outlook: the belief that anytime kids are doing anything on their own, they are automatically under threat. But that outlook is wrong. The crime rate in America is back down to what it was in 1963, which means that most of today's parents grew up playing outside when it was <em>more</em> dangerous than it is today. And it hasn't gotten safer because we're hovering over our kids. All violent crime is down, including against adults.</p>
<h1>Danger Things</h1>
<p>And yet it doesn't feel safer. A 2010 study found "kidnapping" to be the top parental fear, despite the fact that merely being a passenger in a car is far more dangerous. Nine kids were kidnapped and murdered by strangers in 2011, while 1,140 died in vehicles that same year. While Harvard psychologist Steven Pinker writes in 2011's <em>The Better Angels of Our Nature</em> that life in most countries is safer today than at any time in human history, the press keeps pushing paranoia. This makes stepping back feel doubly risky: There's the fear of child kidnappers <em>and</em> the fear of Child Protective Services.</p>
<p>At times, it seems like our culture is conjuring dangers out of thin air, just to have something new to worry about. Thus, the Boulder Public Library in Colorado recently forbade anyone under 12 to enter without an adult, because "children may encounter hazards such as stairs, elevators, doors, furniture, electrical equipment, or other library patrons." Ah, yes, kids and library furniture. Always a lethal combo.</p>
<p>Happily, the library backed off that rule, perhaps thanks to merciless mocking in the media. But saner minds don't always prevail. At Mesa Elementary School, which also happens to be in Boulder, students got a list of the items they could not bring to the science fair. These included "chemicals," "plants in soil," and "organisms (living or dead)." And we wonder why American children score so low on international tests.</p>
<p>But perhaps the single best example of how fantastically fearful we've become occurred when the city of Richland, Washington, got rid of all the swings on its school playgrounds. The love of swinging is probably older than humanity itself, given our arboreal origins. But as a school district spokesman explained, "Swings have been determined to be the most unsafe of all the playground equipment on a playground."</p>
<p>You may think your town has avoided such overkill, but is there a merry-go-round at your local park, or a see-saw? Most likely they, too, have gone the way of lawn darts. The Consumer Product Safety Commission even warns parks of "tripping hazards, like&hellip;tree stumps and rocks," a fact unearthed (so to speak) by Philip Howard, author of 2010's <em>Life Without Lawyers</em>.</p>
<p>The problem is that kids learn by doing. Trip over a tree stump and you learn to look down. There's an old saying: <em>Prepare your child for the path, not the path for your child.</em> We're doing the opposite.</p>
<p>Ironically, there are real health dangers in <em>not</em> walking, or biking, or hopping over that stump. A Johns Hopkins study this summer found that the typical 19-year-old is as sedentary as a 65-year-old. The Army is worried that its recruits don't know how to skip or do somersaults.</p>
<p>But the cost of shielding kids from risks goes well beyond the physical, as a robust body of research has shown.</p>
<h1>Of Trophies and Traumas</h1>
<p>A few years ago, Boston College psychology professor emeritus Peter Gray was invited by the head of counseling services at a major university to a conference on "the decline in resilience among students." The organizer said that emergency counseling calls had doubled in the last five years. What's more, callers were seeking help coping with everyday problems, such as arguments with a roommate. Two students had dialed in because they'd found a mouse in their apartment. They also called the police, who came and set a mousetrap. And that's not to mention the sensitivity around grades. To some students, a B is the end of the world. (To some parents, too.)</p>
<p><span class="pullquote">Free play has little in common with the "play" we give children today. In organized activities, adults run the show. It's only when the grown-ups aren't around that the kids get to take over. Play is training for adulthood.</span></p>
<p>Part of the rise in calls could be attributed to the fact that admitting mental health issues no longer carries the stigma it once did, an undeniably positive development. But it could also be a sign, Gray realized, that failing at basic "adulting" no longer carries the stigma <em>it</em> once did. And that is far more troubling.</p>
<p>Is this outcome the apotheosis of participation-trophy culture? It's easy to scoff at a society that teaches kids that everything they do deserves applause. But more disturbing is the possibility that those trophies taught kids the opposite lesson: that they're so easily hurt, they can't handle the sad truth that they're not the best at something.</p>
<p>Not letting your kid climb a tree because he might fall robs him of a classic childhood experience. But being emotionally overprotective takes away something else. "We have raised a generation of young people who have not been given the opportunity to&hellip;experience failure and realize they can survive it," Gray has said. When Lenore's son came in eighth out of nine teams in a summer camp bowling league, he got an eighth-place trophy. The moral was clear: We don't think you can cope with the negative emotions of finishing second-to-last.</p>
<p>Of course, it's natural to want to see kids happy. But the real secret to happiness isn't more high fives; it's developing emotional resilience. In our mania for physical safety, coupled with our recent tendency to talk about "emotional safety," we have systematically deprived our children of the thousands of challenging&mdash;and sometimes upsetting&mdash;experiences that they need in order to learn that resiliency. And in our quest to protect them, we have stolen from children the best resilience training known to man: free play.</p>
<h1>Play's the Thing</h1>
<p>All mammals play. It is a drive installed by Mother Nature. Hippos do backflips in the water. Dogs fetch sticks. And gazelles run around, engaging in a game that looks an awful lot like tag.</p>
<p>Why would they do that? They're wasting valuable calories and exposing themselves to predators. Shouldn't they just sit quietly next to their mama gazelles, exploring the world through the magic of PBS Kids?</p>
<p>It must be because play is even more important to their long-term survival than simply being "safe." Gray's main body of research is on the importance of free play, and he stresses that it has little in common with the "play" we give kids today. In organized activities&mdash;Little League, for example&mdash;adults run the show. It's only when the grown-ups aren't around that the kids get to take over. Play is training for adulthood.</p>
<p>In free play, ideally with kids of mixed ages, the children decide what to do and how to do it. That's teamwork, literally. The little kids desperately want to be like the bigger kids, so instead of bawling when they strike out during a sandlot baseball game, they work hard to hold themselves together. This is the foundation of maturity.</p>
<p>The older kids, meanwhile, throw the ball more softly to the younger ones. They're learning empathy. And if someone yells, "Let's play on just one leg!"&mdash;something they couldn't do at Little League, with championships (and trophies!) on the line&mdash;the kids discover what it means to come up with and try out a different way of doing things. In Silicon Valley terms, they "pivot" and adopt a "new business model." They also learn that they, not just grown-ups, can collectively remake the rules to suit their needs. That's called participatory democracy.</p>
<p>Best of all, without adults intervening, the kids have to do all the problem solving for themselves, from deciding what game to play to making sure the teams are roughly equal. Then, when there's an argument, they have to resolve it themselves. That's a tough skill to learn, but the drive to continue playing motivates them to work things out. To get back to having fun, they first have to come up with a solution, so they do. This teaches them that they can disagree, hash it out, and&mdash;perhaps with some grumbling&mdash;move on.</p>
<p>These are the very skills that are suddenly in short supply on college campuses.</p>
<p>"Free play is the means by which children learn to make friends, overcome their fears, solve their own problems and generally take control of their own lives," Gray writes in 2013's <em>Free to Learn</em> (Basic Books). "Nothing we do, no amount of toys we buy or 'quality time' or special training we give our children, can compensate for the freedom we take away. The things that children learn through their own initiatives, in free play, cannot be taught in other ways."</p>
<p>Unstructured, unsupervised time for play is one of the most important things we have to give back to kids if we want them to be strong and happy and resilient.</p>
<h1>Where Have All the Paperboys Gone?</h1>
<p>It's not just that kids aren't playing much on their own. These days, they're not doing much of anything on their own. In an article in <em>The Atlantic,</em> Hanna Rosin admits that "when my daughter was 10, my husband and I suddenly realized that in her whole life, she had probably not spent more than 10 minutes unsupervised by an adult."</p>
<p>In earlier generations, this would have seemed a bizarre and wildly overprotective upbringing. Society had certain age-related milestones that most people agreed on. Kids might be trusted to walk to school by first grade. They might get a latchkey at 8, take on a newspaper route around 10, start babysitting at 12. But over the past generation or so, those milestones disappeared&mdash;buried by fears of kidnapping, the rise of supervised activities, and the pre-eminence of homework. Parents today know all about the academic milestones their kids are supposed to reach, but not about the moments when kids used to start joining the world.</p>
<p>It's not necessarily their fault. Calls to eight newspapers in North Carolina found none that would take anyone under the age of 18 to deliver papers. A police chief in New Albany, Ohio, went on record saying kids shouldn't be outside on their own till age 16, "the threshold where you see children getting a little bit more freedom." A study in Britain found that while just under half of all 16- to 17-year-olds had jobs as recently as 1992, today that number is 20 percent.</p>
<p>The responsibility expected of kids not so long ago has become almost inconceivable. Published in 1979, the book <em>Your 6-Year-old: Loving and Defiant</em> includes a simple checklist for what a child entering first grade should be able to do: Can he draw and color and stay within the lines of the design being colored? Can he ride a small two-wheeled bicycle without helper wheels? Can he travel alone in the neighborhood (four to eight blocks) to a store, school, playground, or friend's home?</p>
<p>Hang on. Walk to the store at 6&mdash;<em>alone</em>?</p>
<p>It's tempting to blame "helicopter parents" for today's less resilient kids. But when all the first-graders are walking themselves to school, it's easy to add yours to the mix. When your child is the only one, it's harder. And that's where we are today. Norms have dramatically changed. The kind of freedom that seemed unremarkable a generation ago has become taboo, and in some cases even illegal.</p>
<h1>A Very Hampered Halloween</h1>
<p>In Waynesboro, Georgia, "trick or treaters" must be 12 or younger; they must be in a costume; and they must be accompanied by an adult at least 21 years of age. So if you have kids who are 15, 10, and 8, you can't send them out together. The 15-year-old is not allowed to dress up, yet she won't be considered old enough to supervise her siblings for another six years. And this is on the one night of the entire year we traditionally let children pretend to be adults.</p>
<p>Other schools and community centers now send letters home asking parents not to let their children wear scary costumes. Some even organize "trunk or treats"&mdash;cars parked in a circle, trunks open and filled with candy, thus saving the kids from having to walk around the neighborhood or knock on doors. (That would be tiring <em>and</em> terrifying.) If this is childhood, is it any wonder college kids also expect to be micromanaged on Halloween?</p>
<p>At Yale in 2015, after 13 college administrators signed a letter outlining appropriate vs. inappropriate costume choices for students, the childhood development expert and campus lecturer Erika Christakis suggested that it would be better to allow kids to think for themselves. After all, Halloween is supposed to be about pushing boundaries. "Is there no room anymore for a child or young person to be a little obnoxious&hellip;or, yes, offensive?" she wrote. "Have we lost faith in young people's capacity&mdash;your capacity&mdash;to ignore or reject things that trouble you?"</p>
<p>Apparently, yes. Angry students mobbed her husband, the professor Nicholas Christakis, surrounding him in the courtyard of the residential college where he served as master. They screamed obscenities and demanded he apologize for believing, along with his wife, that college students are in fact capable of handling offensive costumes on Halloween. "Be quiet!" a student shouted at him at one point. "As master, it is your job to create a place of comfort and home for the students!" She did not take kindly to his response that, to the contrary, he sees it as his job to create a space where students can grow intellectually.</p>
<p>As it turns out, Halloween is the perfect Petri dish for observing what we have done to childhood. We didn't think anything was safe enough for young people. And now we are witnessing the results.</p>
<h1>No Fun and No Joy</h1>
<p>When parents curtail their kids' independence, they're not just depriving the younglings of childhood fun. They are denying themselves the grown-up joy of seeing their kids do something smart, brave, or kind <em>without</em> parental guidance.</p>
<p>It's the kind of joy described by a <em>Washington Post</em> columnist who answered the phone one day and was shocked to find her 8-year-old son on the other end. He'd accidentally gone home when he was supposed to stay after school. Realizing she wasn't there, he decided to walk to the store a few blocks away&mdash;his first time. The mom raced over, fearing God knows what, and rushed in only to find her son happily helping the shopkeeper stock the shelves with meat. He'd had a snack and done his homework, too. It was an afternoon he'd never forget, and neither would his very proud mother.</p>
<p>When we don't let our kids do anything on their own, we don't get to see just how competent they can be&mdash;and isn't that, ultimately, the greatest reward of parenting? We need to make it easier for grown-ups to let go while living in a society that keeps warning them not to. And we need to make sure they won't get arrested for it.</p>
<h1>What Is To Be Done?</h1>
<p>By trying to keep children safe from all risks, obstacles, hurt feelings, and fears, our culture has taken away the opportunities they need to become successful adults. In treating them as fragile&mdash;emotionally, socially, and physically&mdash;society actually makes them so.</p>
<p>To combat this problem, we have established a new nonpartisan nonprofit, the Let Grow Foundation. Our goal is to restore resilience by overthrowing the culture of overprotection. We teamed up with Gray, the professor whose research we highlighted above, and FIRE's Shuchman, a New York investment fund manager who is now our chairman.</p>
<p>We are building an organization that seeks to change the social norms, policies, and laws that pressure and intimidate parents, schools, and towns into coddling their kids. We will research the effects of excessive caution, study the link between independence and success, and launch projects to give kids back some free time and free play. Most of all, the Let Grow Foundation will reject the assumption of fragility and promote intellectual, physical, and emotional resilience.</p>
<p>Children know that their parents had more freedom to roam than they do, and more unscheduled time to read or tinker or explore. They also realize that older generations were trusted to roll with some punches, at school and beyond. We hope kids today will start demanding that same independence and respect for themselves. It's their freedom that has been chiseled away, after all.</p>
<p>We want them to insist on their right to engage not just with the physical world, but also with the world of ideas. We want them to hear, read, and voice opinions that go against the grain. We want them to be insulted by the assumption that they and their classmates are so easily hurt that arguments must stop before they start. To this end, we hope to encourage their skepticism about the programs and policies that are ostensibly there to "protect" them from discomfort.</p>
<p>If this effort is successful, we'll soon see kids outside again. Common setbacks will be considered "resilience moments" rather than traumas. Children will read widely, express themselves freely, and work through disagreements without automatically calling on authority figures to solve their problems for them. The more adults step back, the more we believe kids will step up, growing brave in the face of risk and just plain happy in their independence.</p>
<p>Children today are safer and smarter than this culture gives them credit for. They deserve the freedom we had. The country's future prosperity and freedom depend on it.</p>						</div>

<amp-ad width="1" height="1" type="doubleclick" data-slot="/1006247/amp_mobile_1x1"></amp-ad><!-- Zergnet Tags - Reason Google AMP Below Article --><!--
<amp-embed width="780" height="100"
           heights="(max-width:370px) 188%, (max-width:450px) 171%, (max-width:550px) 152%, (max-width:600px) 141%, (max-width:645px) 138%, 138%"
           layout="responsive"
           type="zergnet"
           data-zergid="58937">
</amp-embed>
--><amp-embed width="100" height="100" type="taboola" layout="responsive" heights="(min-width:1835px) 559%, (min-width:1507px) 564%, (min-width:1237px) 571%, (min-width:1044px) 578%, (min-width:869px) 587%, (min-width:715px) 598%, (min-width:612px) 613%, (min-width:533px) 629%, (min-width:460px) 648%, (min-width:401px) 670%, (min-width:352px) 694%, 723%" data-publisher="reason" data-mode="thumbnails-b-amp" data-placement="Mobile Below Article Thumbnails AMP" data-target_type="mix" data-article="auto"></amp-embed><div>
							<a href="//reason.com" class="subtitle">More Top Stories</a>
						</div>
					</article><!-- end .post --><amp-analytics type="googleanalytics" id="analytics1"><script type="application/json">
{
  "vars": {
    "account": "UA-283675-5"
		,"author": "lenore-skenazy"  },
  "triggers": {
    "trackPageview": {
      "on": "visible",
      "request": "pageview"
    }
  }
}
</script></amp-analytics><amp-analytics type="googleanalytics" id="analyticsRollup"><script type="application/json">
{
  "vars": {
    "account": "UA-283675-6"
		,"author": "lenore-skenazy"  },
  "triggers": {
    "trackPageview": {
      "on": "visible",
      "request": "pageview"
    }
  }
}
</script></amp-analytics><amp-analytics type="parsely"><script type="application/json">
	    {
	        "vars": {
	            "apikey": "reason.com"
	        }
	    }
	</script></amp-analytics></body></html>
